varying vec2 p_textureCoord;

uniform vec4 p_color;
uniform sampler2D base_texture;
uniform float base_time;
uniform vec2 wave_mag;
uniform vec2 wave_freq;
uniform vec2 phase_mult;
uniform vec2 wave_number;

void main()
{
    vec4 baseColor = texture2D(base_texture, p_textureCoord);
    float baseSum = baseColor.x + baseColor.y + baseColor.z;
    vec2 calc_vec = vec2(p_textureCoord.x - 0.5, p_textureCoord.y - 0.5);  

    vec2 real_texCoord = vec2(p_textureCoord.x + wave_mag.x * 
                                      sin(wave_number.x * calc_vec.x + wave_freq.x * base_time + phase_mult.x * calc_vec.y),
                                      p_textureCoord.y + wave_mag.y * 
                                      cos(wave_number.y * calc_vec.y + wave_freq.y * base_time + phase_mult.y * calc_vec.x));


    vec4 resultColor = texture2D(base_texture, real_texCoord) * p_color;
    gl_FragColor = resultColor;
}
